Imports System.Data
Imports System.Data.OleDb

Module Module1

    Sub Main()
        ' Ouvrir une connexion vers le conteneur de donnes.
        Dim cn As OleDbConnection = New OleDbConnection()
        cn.ConnectionString = "Provider=SQLOLEDB.1;" & _
               "Integrated Security=SSPI;" & _
               "Persist Security Info=False;" & _
               "Initial Catalog=Cars;" & _
               "Data Source=(local);"
        cn.Open()

        ' Construire un objet de commande pour la procdure stocke.
        Dim myCommand As OleDbCommand = New OleDbCommand("GetPetName", cn)
        myCommand.CommandType = CommandType.StoredProcedure

        ' Crer les paramtres d'appel.
        Dim theParam As OleDbParameter = New OleDbParameter()

        ' Entre.
        theParam.ParameterName = "@carID"
        theParam.OleDbType = OleDbType.Integer
        theParam.Direction = ParameterDirection.Input
        theParam.Value = 1   ' Car ID = 1.
        myCommand.Parameters.Add(theParam)

        ' Sortie.
        theParam = New OleDbParameter()
        theParam.ParameterName = "@petName"
        theParam.OleDbType = OleDbType.Char
        theParam.Size = 20
        theParam.Direction = ParameterDirection.Output
        myCommand.Parameters.Add(theParam)

        ' Excuter la commande!
        myCommand.ExecuteNonQuery()

        ' Afficher le rsultat.
        Console.WriteLine("Informations de la procdure stocke:")
        Console.WriteLine("ID voiture: {0}", myCommand.Parameters("@carID").Value)
        Console.WriteLine("Surnom: {0}", myCommand.Parameters("@petName").Value)

    End Sub

End Module
